package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeploymentTarget(
    deploymentTargetType: Option[
      zio.aws.codedeploy.model.DeploymentTargetType
    ] = None,
    instanceTarget: Option[zio.aws.codedeploy.model.InstanceTarget] = None,
    lambdaTarget: Option[zio.aws.codedeploy.model.LambdaTarget] = None,
    ecsTarget: Option[zio.aws.codedeploy.model.ECSTarget] = None,
    cloudFormationTarget: Option[
      zio.aws.codedeploy.model.CloudFormationTarget
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentTarget = {
    import DeploymentTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
      .builder()
      .optionallyWith(deploymentTargetType.map(value => value.unwrap))(
        _.deploymentTargetType
      )
      .optionallyWith(instanceTarget.map(value => value.buildAwsValue()))(
        _.instanceTarget
      )
      .optionallyWith(lambdaTarget.map(value => value.buildAwsValue()))(
        _.lambdaTarget
      )
      .optionallyWith(ecsTarget.map(value => value.buildAwsValue()))(
        _.ecsTarget
      )
      .optionallyWith(cloudFormationTarget.map(value => value.buildAwsValue()))(
        _.cloudFormationTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentTarget.ReadOnly =
    zio.aws.codedeploy.model.DeploymentTarget.wrap(buildAwsValue())
}
object DeploymentTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentTarget =
      zio.aws.codedeploy.model.DeploymentTarget(
        deploymentTargetType.map(value => value),
        instanceTarget.map(value => value.asEditable),
        lambdaTarget.map(value => value.asEditable),
        ecsTarget.map(value => value.asEditable),
        cloudFormationTarget.map(value => value.asEditable)
      )
    def deploymentTargetType
        : Option[zio.aws.codedeploy.model.DeploymentTargetType]
    def instanceTarget: Option[zio.aws.codedeploy.model.InstanceTarget.ReadOnly]
    def lambdaTarget: Option[zio.aws.codedeploy.model.LambdaTarget.ReadOnly]
    def ecsTarget: Option[zio.aws.codedeploy.model.ECSTarget.ReadOnly]
    def cloudFormationTarget
        : Option[zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly]
    def getDeploymentTargetType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentTargetType] =
      AwsError.unwrapOptionField("deploymentTargetType", deploymentTargetType)
    def getInstanceTarget
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.InstanceTarget.ReadOnly] =
      AwsError.unwrapOptionField("instanceTarget", instanceTarget)
    def getLambdaTarget
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LambdaTarget.ReadOnly] =
      AwsError.unwrapOptionField("lambdaTarget", lambdaTarget)
    def getEcsTarget
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ECSTarget.ReadOnly] =
      AwsError.unwrapOptionField("ecsTarget", ecsTarget)
    def getCloudFormationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormationTarget", cloudFormationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
  ) extends zio.aws.codedeploy.model.DeploymentTarget.ReadOnly {
    override val deploymentTargetType
        : Option[zio.aws.codedeploy.model.DeploymentTargetType] = scala
      .Option(impl.deploymentTargetType())
      .map(value => zio.aws.codedeploy.model.DeploymentTargetType.wrap(value))
    override val instanceTarget
        : Option[zio.aws.codedeploy.model.InstanceTarget.ReadOnly] = scala
      .Option(impl.instanceTarget())
      .map(value => zio.aws.codedeploy.model.InstanceTarget.wrap(value))
    override val lambdaTarget
        : Option[zio.aws.codedeploy.model.LambdaTarget.ReadOnly] = scala
      .Option(impl.lambdaTarget())
      .map(value => zio.aws.codedeploy.model.LambdaTarget.wrap(value))
    override val ecsTarget
        : Option[zio.aws.codedeploy.model.ECSTarget.ReadOnly] = scala
      .Option(impl.ecsTarget())
      .map(value => zio.aws.codedeploy.model.ECSTarget.wrap(value))
    override val cloudFormationTarget
        : Option[zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly] = scala
      .Option(impl.cloudFormationTarget())
      .map(value => zio.aws.codedeploy.model.CloudFormationTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
  ): zio.aws.codedeploy.model.DeploymentTarget.ReadOnly = new Wrapper(impl)
}
