package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDeploymentGroupResponse(
    hooksNotCleanedUp: Option[
      Iterable[zio.aws.codedeploy.model.AutoScalingGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse = {
    import UpdateDeploymentGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse
      .builder()
      .optionallyWith(
        hooksNotCleanedUp.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hooksNotCleanedUp)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly =
    zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.wrap(buildAwsValue())
}
object UpdateDeploymentGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.UpdateDeploymentGroupResponse =
      zio.aws.codedeploy.model.UpdateDeploymentGroupResponse(
        hooksNotCleanedUp.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hooksNotCleanedUp
        : Option[List[zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly]]
    def getHooksNotCleanedUp: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("hooksNotCleanedUp", hooksNotCleanedUp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse
  ) extends zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly {
    override val hooksNotCleanedUp
        : Option[List[zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly]] =
      scala
        .Option(impl.hooksNotCleanedUp())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.AutoScalingGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse
  ): zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly =
    new Wrapper(impl)
}
