package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ApplicationId
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationId: Option[ApplicationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly =
    zio.aws.codedeploy.model.CreateApplicationResponse.wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateApplicationResponse =
      zio.aws.codedeploy.model
        .CreateApplicationResponse(applicationId.map(value => value))
    def applicationId: Option[ApplicationId]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse
  ) extends zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse
  ): zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
