package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{TriggerTargetArn, TriggerName}
import scala.jdk.CollectionConverters._
final case class TriggerConfig(
    triggerName: Option[TriggerName] = None,
    triggerTargetArn: Option[TriggerTargetArn] = None,
    triggerEvents: Option[Iterable[zio.aws.codedeploy.model.TriggerEventType]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TriggerConfig = {
    import TriggerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TriggerConfig
      .builder()
      .optionallyWith(
        triggerName.map(value => TriggerName.unwrap(value): java.lang.String)
      )(_.triggerName)
      .optionallyWith(
        triggerTargetArn.map(value =>
          TriggerTargetArn.unwrap(value): java.lang.String
        )
      )(_.triggerTargetArn)
      .optionallyWith(
        triggerEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.triggerEventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TriggerConfig.ReadOnly =
    zio.aws.codedeploy.model.TriggerConfig.wrap(buildAwsValue())
}
object TriggerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TriggerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TriggerConfig =
      zio.aws.codedeploy.model.TriggerConfig(
        triggerName.map(value => value),
        triggerTargetArn.map(value => value),
        triggerEvents.map(value => value)
      )
    def triggerName: Option[TriggerName]
    def triggerTargetArn: Option[TriggerTargetArn]
    def triggerEvents: Option[List[zio.aws.codedeploy.model.TriggerEventType]]
    def getTriggerName: ZIO[Any, AwsError, TriggerName] =
      AwsError.unwrapOptionField("triggerName", triggerName)
    def getTriggerTargetArn: ZIO[Any, AwsError, TriggerTargetArn] =
      AwsError.unwrapOptionField("triggerTargetArn", triggerTargetArn)
    def getTriggerEvents
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.TriggerEventType]] =
      AwsError.unwrapOptionField("triggerEvents", triggerEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TriggerConfig
  ) extends zio.aws.codedeploy.model.TriggerConfig.ReadOnly {
    override val triggerName: Option[TriggerName] = scala
      .Option(impl.triggerName())
      .map(value => zio.aws.codedeploy.model.primitives.TriggerName(value))
    override val triggerTargetArn: Option[TriggerTargetArn] = scala
      .Option(impl.triggerTargetArn())
      .map(value => zio.aws.codedeploy.model.primitives.TriggerTargetArn(value))
    override val triggerEvents
        : Option[List[zio.aws.codedeploy.model.TriggerEventType]] = scala
      .Option(impl.triggerEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.TriggerEventType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TriggerConfig
  ): zio.aws.codedeploy.model.TriggerConfig.ReadOnly = new Wrapper(impl)
}
