package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentId
import scala.jdk.CollectionConverters._
final case class RelatedDeployments(
    autoUpdateOutdatedInstancesRootDeploymentId: Option[DeploymentId] = None,
    autoUpdateOutdatedInstancesDeploymentIds: Option[Iterable[DeploymentId]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RelatedDeployments = {
    import RelatedDeployments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RelatedDeployments
      .builder()
      .optionallyWith(
        autoUpdateOutdatedInstancesRootDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.autoUpdateOutdatedInstancesRootDeploymentId)
      .optionallyWith(
        autoUpdateOutdatedInstancesDeploymentIds.map(value =>
          value.map { item =>
            DeploymentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoUpdateOutdatedInstancesDeploymentIds)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.RelatedDeployments.ReadOnly =
    zio.aws.codedeploy.model.RelatedDeployments.wrap(buildAwsValue())
}
object RelatedDeployments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RelatedDeployments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RelatedDeployments =
      zio.aws.codedeploy.model.RelatedDeployments(
        autoUpdateOutdatedInstancesRootDeploymentId.map(value => value),
        autoUpdateOutdatedInstancesDeploymentIds.map(value => value)
      )
    def autoUpdateOutdatedInstancesRootDeploymentId: Option[DeploymentId]
    def autoUpdateOutdatedInstancesDeploymentIds: Option[List[DeploymentId]]
    def getAutoUpdateOutdatedInstancesRootDeploymentId
        : ZIO[Any, AwsError, DeploymentId] = AwsError.unwrapOptionField(
      "autoUpdateOutdatedInstancesRootDeploymentId",
      autoUpdateOutdatedInstancesRootDeploymentId
    )
    def getAutoUpdateOutdatedInstancesDeploymentIds
        : ZIO[Any, AwsError, List[DeploymentId]] = AwsError.unwrapOptionField(
      "autoUpdateOutdatedInstancesDeploymentIds",
      autoUpdateOutdatedInstancesDeploymentIds
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RelatedDeployments
  ) extends zio.aws.codedeploy.model.RelatedDeployments.ReadOnly {
    override val autoUpdateOutdatedInstancesRootDeploymentId
        : Option[DeploymentId] = scala
      .Option(impl.autoUpdateOutdatedInstancesRootDeploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val autoUpdateOutdatedInstancesDeploymentIds
        : Option[List[DeploymentId]] = scala
      .Option(impl.autoUpdateOutdatedInstancesDeploymentIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.primitives.DeploymentId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RelatedDeployments
  ): zio.aws.codedeploy.model.RelatedDeployments.ReadOnly = new Wrapper(impl)
}
