package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Timestamp, LifecycleEventName}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LifecycleEvent(
    lifecycleEventName: Option[LifecycleEventName] = None,
    diagnostics: Option[zio.aws.codedeploy.model.Diagnostics] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    status: Option[zio.aws.codedeploy.model.LifecycleEventStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LifecycleEvent = {
    import LifecycleEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
      .builder()
      .optionallyWith(
        lifecycleEventName.map(value =>
          LifecycleEventName.unwrap(value): java.lang.String
        )
      )(_.lifecycleEventName)
      .optionallyWith(diagnostics.map(value => value.buildAwsValue()))(
        _.diagnostics
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LifecycleEvent.ReadOnly =
    zio.aws.codedeploy.model.LifecycleEvent.wrap(buildAwsValue())
}
object LifecycleEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LifecycleEvent =
      zio.aws.codedeploy.model.LifecycleEvent(
        lifecycleEventName.map(value => value),
        diagnostics.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value)
      )
    def lifecycleEventName: Option[LifecycleEventName]
    def diagnostics: Option[zio.aws.codedeploy.model.Diagnostics.ReadOnly]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def status: Option[zio.aws.codedeploy.model.LifecycleEventStatus]
    def getLifecycleEventName: ZIO[Any, AwsError, LifecycleEventName] =
      AwsError.unwrapOptionField("lifecycleEventName", lifecycleEventName)
    def getDiagnostics
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.Diagnostics.ReadOnly] =
      AwsError.unwrapOptionField("diagnostics", diagnostics)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LifecycleEventStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
  ) extends zio.aws.codedeploy.model.LifecycleEvent.ReadOnly {
    override val lifecycleEventName: Option[LifecycleEventName] = scala
      .Option(impl.lifecycleEventName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.LifecycleEventName(value)
      )
    override val diagnostics
        : Option[zio.aws.codedeploy.model.Diagnostics.ReadOnly] = scala
      .Option(impl.diagnostics())
      .map(value => zio.aws.codedeploy.model.Diagnostics.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.codedeploy.model.LifecycleEventStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.codedeploy.model.LifecycleEventStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
  ): zio.aws.codedeploy.model.LifecycleEvent.ReadOnly = new Wrapper(impl)
}
