package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentStatus {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentStatus
  ): zio.aws.codedeploy.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.CREATED =>
      val r = Created
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.QUEUED =>
      val r = Queued
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.BAKING =>
      val r = Baking
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.READY =>
      val r = Ready
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Created extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.CREATED
  }
  case object Queued extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.QUEUED
  }
  case object InProgress extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.IN_PROGRESS
  }
  case object Baking extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.BAKING
  }
  case object Succeeded extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.FAILED
  }
  case object Stopped extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.STOPPED
  }
  case object Ready extends zio.aws.codedeploy.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentStatus =
      software.amazon.awssdk.services.codedeploy.model.DeploymentStatus.READY
  }
}
