package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait TrafficRoutingType {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType
}
object TrafficRoutingType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType
  ): zio.aws.codedeploy.model.TrafficRoutingType = value match {
    case software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.TIME_BASED_CANARY =>
      val r = TimeBasedCanary
      r
    case software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.TIME_BASED_LINEAR =>
      val r = TimeBasedLinear
      r
    case software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.ALL_AT_ONCE =>
      val r = AllAtOnce
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.TrafficRoutingType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType =
      software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.UNKNOWN_TO_SDK_VERSION
  }
  case object TimeBasedCanary
      extends zio.aws.codedeploy.model.TrafficRoutingType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType =
      software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.TIME_BASED_CANARY
  }
  case object TimeBasedLinear
      extends zio.aws.codedeploy.model.TrafficRoutingType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType =
      software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.TIME_BASED_LINEAR
  }
  case object AllAtOnce extends zio.aws.codedeploy.model.TrafficRoutingType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType =
      software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType.ALL_AT_ONCE
  }
}
