package zio.aws.codedeploy.model
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.MinimumHealthyHostsValue
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MinimumHealthyHosts(
    `type`: Optional[zio.aws.codedeploy.model.MinimumHealthyHostsType] =
      Optional.Absent,
    value: Optional[MinimumHealthyHostsValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts = {
    import MinimumHealthyHosts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => MinimumHealthyHostsValue.unwrap(value): Integer)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly =
    zio.aws.codedeploy.model.MinimumHealthyHosts.wrap(buildAwsValue())
}
object MinimumHealthyHosts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.MinimumHealthyHosts =
      zio.aws.codedeploy.model.MinimumHealthyHosts(
        `type`.map(value => value),
        value.map(value => value)
      )
    def `type`: Optional[zio.aws.codedeploy.model.MinimumHealthyHostsType]
    def value: Optional[MinimumHealthyHostsValue]
    def getType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.MinimumHealthyHostsType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, MinimumHealthyHostsValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts
  ) extends zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly {
    override val `type`
        : Optional[zio.aws.codedeploy.model.MinimumHealthyHostsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.codedeploy.model.MinimumHealthyHostsType.wrap(value)
        )
    override val value: Optional[MinimumHealthyHostsValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.codedeploy.model.primitives.MinimumHealthyHostsValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts
  ): zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly = new Wrapper(impl)
}
