package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  Description,
  DeploymentConfigName,
  DeploymentGroupName,
  ApplicationName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeploymentRequest(
    applicationName: ApplicationName,
    deploymentGroupName: Optional[DeploymentGroupName] = Optional.Absent,
    revision: Optional[zio.aws.codedeploy.model.RevisionLocation] =
      Optional.Absent,
    deploymentConfigName: Optional[DeploymentConfigName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    ignoreApplicationStopFailures: Optional[Boolean] = Optional.Absent,
    targetInstances: Optional[zio.aws.codedeploy.model.TargetInstances] =
      Optional.Absent,
    autoRollbackConfiguration: Optional[
      zio.aws.codedeploy.model.AutoRollbackConfiguration
    ] = Optional.Absent,
    updateOutdatedInstancesOnly: Optional[Boolean] = Optional.Absent,
    fileExistsBehavior: Optional[zio.aws.codedeploy.model.FileExistsBehavior] =
      Optional.Absent,
    overrideAlarmConfiguration: Optional[
      zio.aws.codedeploy.model.AlarmConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest = {
    import CreateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        deploymentGroupName.map(value =>
          DeploymentGroupName.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupName)
      .optionallyWith(revision.map(value => value.buildAwsValue()))(_.revision)
      .optionallyWith(
        deploymentConfigName.map(value =>
          DeploymentConfigName.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        ignoreApplicationStopFailures.map(value => value: java.lang.Boolean)
      )(_.ignoreApplicationStopFailures)
      .optionallyWith(targetInstances.map(value => value.buildAwsValue()))(
        _.targetInstances
      )
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .optionallyWith(
        updateOutdatedInstancesOnly.map(value => value: java.lang.Boolean)
      )(_.updateOutdatedInstancesOnly)
      .optionallyWith(fileExistsBehavior.map(value => value.unwrap))(
        _.fileExistsBehavior
      )
      .optionallyWith(
        overrideAlarmConfiguration.map(value => value.buildAwsValue())
      )(_.overrideAlarmConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.CreateDeploymentRequest.ReadOnly =
    zio.aws.codedeploy.model.CreateDeploymentRequest.wrap(buildAwsValue())
}
object CreateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateDeploymentRequest =
      zio.aws.codedeploy.model.CreateDeploymentRequest(
        applicationName,
        deploymentGroupName.map(value => value),
        revision.map(value => value.asEditable),
        deploymentConfigName.map(value => value),
        description.map(value => value),
        ignoreApplicationStopFailures.map(value => value),
        targetInstances.map(value => value.asEditable),
        autoRollbackConfiguration.map(value => value.asEditable),
        updateOutdatedInstancesOnly.map(value => value),
        fileExistsBehavior.map(value => value),
        overrideAlarmConfiguration.map(value => value.asEditable)
      )
    def applicationName: ApplicationName
    def deploymentGroupName: Optional[DeploymentGroupName]
    def revision: Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def deploymentConfigName: Optional[DeploymentConfigName]
    def description: Optional[Description]
    def ignoreApplicationStopFailures: Optional[Boolean]
    def targetInstances
        : Optional[zio.aws.codedeploy.model.TargetInstances.ReadOnly]
    def autoRollbackConfiguration
        : Optional[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly]
    def updateOutdatedInstancesOnly: Optional[Boolean]
    def fileExistsBehavior
        : Optional[zio.aws.codedeploy.model.FileExistsBehavior]
    def overrideAlarmConfiguration
        : Optional[zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getDeploymentGroupName: ZIO[Any, AwsError, DeploymentGroupName] =
      AwsError.unwrapOptionField("deploymentGroupName", deploymentGroupName)
    def getRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("revision", revision)
    def getDeploymentConfigName: ZIO[Any, AwsError, DeploymentConfigName] =
      AwsError.unwrapOptionField("deploymentConfigName", deploymentConfigName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIgnoreApplicationStopFailures: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "ignoreApplicationStopFailures",
        ignoreApplicationStopFailures
      )
    def getTargetInstances: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TargetInstances.ReadOnly
    ] = AwsError.unwrapOptionField("targetInstances", targetInstances)
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
    def getUpdateOutdatedInstancesOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "updateOutdatedInstancesOnly",
        updateOutdatedInstancesOnly
      )
    def getFileExistsBehavior
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.FileExistsBehavior] =
      AwsError.unwrapOptionField("fileExistsBehavior", fileExistsBehavior)
    def getOverrideAlarmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "overrideAlarmConfiguration",
      overrideAlarmConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
  ) extends zio.aws.codedeploy.model.CreateDeploymentRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val deploymentGroupName: Optional[DeploymentGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentGroupName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentGroupName(value)
        )
    override val revision
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revision())
        .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val deploymentConfigName: Optional[DeploymentConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfigName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentConfigName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codedeploy.model.primitives.Description(value))
    override val ignoreApplicationStopFailures: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ignoreApplicationStopFailures())
        .map(value => value: Boolean)
    override val targetInstances
        : Optional[zio.aws.codedeploy.model.TargetInstances.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetInstances())
        .map(value => zio.aws.codedeploy.model.TargetInstances.wrap(value))
    override val autoRollbackConfiguration: Optional[
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoRollbackConfiguration())
      .map(value =>
        zio.aws.codedeploy.model.AutoRollbackConfiguration.wrap(value)
      )
    override val updateOutdatedInstancesOnly: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateOutdatedInstancesOnly())
        .map(value => value: Boolean)
    override val fileExistsBehavior
        : Optional[zio.aws.codedeploy.model.FileExistsBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileExistsBehavior())
        .map(value => zio.aws.codedeploy.model.FileExistsBehavior.wrap(value))
    override val overrideAlarmConfiguration
        : Optional[zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideAlarmConfiguration())
        .map(value => zio.aws.codedeploy.model.AlarmConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
  ): zio.aws.codedeploy.model.CreateDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
