package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Value, Key}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EC2TagFilter(
    key: Optional[Key] = Optional.Absent,
    value: Optional[Value] = Optional.Absent,
    `type`: Optional[zio.aws.codedeploy.model.EC2TagFilterType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.EC2TagFilter = {
    import EC2TagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.EC2TagFilter
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.EC2TagFilter.ReadOnly =
    zio.aws.codedeploy.model.EC2TagFilter.wrap(buildAwsValue())
}
object EC2TagFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.EC2TagFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.EC2TagFilter =
      zio.aws.codedeploy.model.EC2TagFilter(
        key.map(value => value),
        value.map(value => value),
        `type`.map(value => value)
      )
    def key: Optional[Key]
    def value: Optional[Value]
    def `type`: Optional[zio.aws.codedeploy.model.EC2TagFilterType]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
    def getType: ZIO[Any, AwsError, zio.aws.codedeploy.model.EC2TagFilterType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.EC2TagFilter
  ) extends zio.aws.codedeploy.model.EC2TagFilter.ReadOnly {
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.codedeploy.model.primitives.Key(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.codedeploy.model.primitives.Value(value))
    override val `type`: Optional[zio.aws.codedeploy.model.EC2TagFilterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codedeploy.model.EC2TagFilterType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.EC2TagFilter
  ): zio.aws.codedeploy.model.EC2TagFilter.ReadOnly = new Wrapper(impl)
}
