package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetGroupPairInfo(
    targetGroups: Optional[Iterable[zio.aws.codedeploy.model.TargetGroupInfo]] =
      Optional.Absent,
    prodTrafficRoute: Optional[zio.aws.codedeploy.model.TrafficRoute] =
      Optional.Absent,
    testTrafficRoute: Optional[zio.aws.codedeploy.model.TrafficRoute] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo = {
    import TargetGroupPairInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(prodTrafficRoute.map(value => value.buildAwsValue()))(
        _.prodTrafficRoute
      )
      .optionallyWith(testTrafficRoute.map(value => value.buildAwsValue()))(
        _.testTrafficRoute
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly =
    zio.aws.codedeploy.model.TargetGroupPairInfo.wrap(buildAwsValue())
}
object TargetGroupPairInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TargetGroupPairInfo =
      zio.aws.codedeploy.model.TargetGroupPairInfo(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prodTrafficRoute.map(value => value.asEditable),
        testTrafficRoute.map(value => value.asEditable)
      )
    def targetGroups
        : Optional[List[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]]
    def prodTrafficRoute
        : Optional[zio.aws.codedeploy.model.TrafficRoute.ReadOnly]
    def testTrafficRoute
        : Optional[zio.aws.codedeploy.model.TrafficRoute.ReadOnly]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getProdTrafficRoute
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TrafficRoute.ReadOnly] =
      AwsError.unwrapOptionField("prodTrafficRoute", prodTrafficRoute)
    def getTestTrafficRoute
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TrafficRoute.ReadOnly] =
      AwsError.unwrapOptionField("testTrafficRoute", testTrafficRoute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
  ) extends zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly {
    override val targetGroups
        : Optional[List[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TargetGroupInfo.wrap(item)
          }.toList
        )
    override val prodTrafficRoute
        : Optional[zio.aws.codedeploy.model.TrafficRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prodTrafficRoute())
        .map(value => zio.aws.codedeploy.model.TrafficRoute.wrap(value))
    override val testTrafficRoute
        : Optional[zio.aws.codedeploy.model.TrafficRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testTrafficRoute())
        .map(value => zio.aws.codedeploy.model.TrafficRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
  ): zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly = new Wrapper(impl)
}
