package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetApplicationResponse(
    application: Optional[zio.aws.codedeploy.model.ApplicationInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse = {
    import GetApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly =
    zio.aws.codedeploy.model.GetApplicationResponse.wrap(buildAwsValue())
}
object GetApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetApplicationResponse =
      zio.aws.codedeploy.model
        .GetApplicationResponse(application.map(value => value.asEditable))
    def application: Optional[zio.aws.codedeploy.model.ApplicationInfo.ReadOnly]
    def getApplication: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.ApplicationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse
  ) extends zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly {
    override val application
        : Optional[zio.aws.codedeploy.model.ApplicationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.application())
        .map(value => zio.aws.codedeploy.model.ApplicationInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse
  ): zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
