package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait ComputePlatform {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.ComputePlatform
}
object ComputePlatform {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.ComputePlatform
  ): zio.aws.codedeploy.model.ComputePlatform = value match {
    case software.amazon.awssdk.services.codedeploy.model.ComputePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.ComputePlatform.SERVER =>
      val r = Server
      r
    case software.amazon.awssdk.services.codedeploy.model.ComputePlatform.LAMBDA =>
      val r = Lambda
      r
    case software.amazon.awssdk.services.codedeploy.model.ComputePlatform.ECS =>
      val r = ECS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ComputePlatform =
      software.amazon.awssdk.services.codedeploy.model.ComputePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object Server extends zio.aws.codedeploy.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ComputePlatform =
      software.amazon.awssdk.services.codedeploy.model.ComputePlatform.SERVER
  }
  case object Lambda extends zio.aws.codedeploy.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ComputePlatform =
      software.amazon.awssdk.services.codedeploy.model.ComputePlatform.LAMBDA
  }
  case object ECS extends zio.aws.codedeploy.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ComputePlatform =
      software.amazon.awssdk.services.codedeploy.model.ComputePlatform.ECS
  }
}
