package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AlarmConfiguration(
    enabled: Optional[Boolean] = Optional.Absent,
    ignorePollAlarmFailure: Optional[Boolean] = Optional.Absent,
    alarms: Optional[Iterable[zio.aws.codedeploy.model.Alarm]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration = {
    import AlarmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        ignorePollAlarmFailure.map(value => value: java.lang.Boolean)
      )(_.ignorePollAlarmFailure)
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly =
    zio.aws.codedeploy.model.AlarmConfiguration.wrap(buildAwsValue())
}
object AlarmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.AlarmConfiguration =
      zio.aws.codedeploy.model.AlarmConfiguration(
        enabled.map(value => value),
        ignorePollAlarmFailure.map(value => value),
        alarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Optional[Boolean]
    def ignorePollAlarmFailure: Optional[Boolean]
    def alarms: Optional[List[zio.aws.codedeploy.model.Alarm.ReadOnly]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIgnorePollAlarmFailure: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("ignorePollAlarmFailure", ignorePollAlarmFailure)
    def getAlarms
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.Alarm.ReadOnly]] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
  ) extends zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val ignorePollAlarmFailure: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ignorePollAlarmFailure())
        .map(value => value: Boolean)
    override val alarms
        : Optional[List[zio.aws.codedeploy.model.Alarm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.Alarm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
  ): zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly = new Wrapper(impl)
}
