package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, DeploymentId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDeploymentsResponse(
    deployments: Optional[Iterable[DeploymentId]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse = {
    import ListDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse
      .builder()
      .optionallyWith(
        deployments.map(value =>
          value.map { item =>
            DeploymentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deployments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ListDeploymentsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentsResponse.wrap(buildAwsValue())
}
object ListDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentsResponse =
      zio.aws.codedeploy.model.ListDeploymentsResponse(
        deployments.map(value => value),
        nextToken.map(value => value)
      )
    def deployments: Optional[List[DeploymentId]]
    def nextToken: Optional[NextToken]
    def getDeployments: ZIO[Any, AwsError, List[DeploymentId]] =
      AwsError.unwrapOptionField("deployments", deployments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse
  ) extends zio.aws.codedeploy.model.ListDeploymentsResponse.ReadOnly {
    override val deployments: Optional[List[DeploymentId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.DeploymentId(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse
  ): zio.aws.codedeploy.model.ListDeploymentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
