package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentTarget(
    deploymentTargetType: Optional[
      zio.aws.codedeploy.model.DeploymentTargetType
    ] = Optional.Absent,
    instanceTarget: Optional[zio.aws.codedeploy.model.InstanceTarget] =
      Optional.Absent,
    lambdaTarget: Optional[zio.aws.codedeploy.model.LambdaTarget] =
      Optional.Absent,
    ecsTarget: Optional[zio.aws.codedeploy.model.ECSTarget] = Optional.Absent,
    cloudFormationTarget: Optional[
      zio.aws.codedeploy.model.CloudFormationTarget
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentTarget = {
    import DeploymentTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
      .builder()
      .optionallyWith(deploymentTargetType.map(value => value.unwrap))(
        _.deploymentTargetType
      )
      .optionallyWith(instanceTarget.map(value => value.buildAwsValue()))(
        _.instanceTarget
      )
      .optionallyWith(lambdaTarget.map(value => value.buildAwsValue()))(
        _.lambdaTarget
      )
      .optionallyWith(ecsTarget.map(value => value.buildAwsValue()))(
        _.ecsTarget
      )
      .optionallyWith(cloudFormationTarget.map(value => value.buildAwsValue()))(
        _.cloudFormationTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentTarget.ReadOnly =
    zio.aws.codedeploy.model.DeploymentTarget.wrap(buildAwsValue())
}
object DeploymentTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentTarget =
      zio.aws.codedeploy.model.DeploymentTarget(
        deploymentTargetType.map(value => value),
        instanceTarget.map(value => value.asEditable),
        lambdaTarget.map(value => value.asEditable),
        ecsTarget.map(value => value.asEditable),
        cloudFormationTarget.map(value => value.asEditable)
      )
    def deploymentTargetType
        : Optional[zio.aws.codedeploy.model.DeploymentTargetType]
    def instanceTarget
        : Optional[zio.aws.codedeploy.model.InstanceTarget.ReadOnly]
    def lambdaTarget: Optional[zio.aws.codedeploy.model.LambdaTarget.ReadOnly]
    def ecsTarget: Optional[zio.aws.codedeploy.model.ECSTarget.ReadOnly]
    def cloudFormationTarget
        : Optional[zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly]
    def getDeploymentTargetType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentTargetType] =
      AwsError.unwrapOptionField("deploymentTargetType", deploymentTargetType)
    def getInstanceTarget
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.InstanceTarget.ReadOnly] =
      AwsError.unwrapOptionField("instanceTarget", instanceTarget)
    def getLambdaTarget
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LambdaTarget.ReadOnly] =
      AwsError.unwrapOptionField("lambdaTarget", lambdaTarget)
    def getEcsTarget
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ECSTarget.ReadOnly] =
      AwsError.unwrapOptionField("ecsTarget", ecsTarget)
    def getCloudFormationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormationTarget", cloudFormationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
  ) extends zio.aws.codedeploy.model.DeploymentTarget.ReadOnly {
    override val deploymentTargetType
        : Optional[zio.aws.codedeploy.model.DeploymentTargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentTargetType())
        .map(value => zio.aws.codedeploy.model.DeploymentTargetType.wrap(value))
    override val instanceTarget
        : Optional[zio.aws.codedeploy.model.InstanceTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTarget())
        .map(value => zio.aws.codedeploy.model.InstanceTarget.wrap(value))
    override val lambdaTarget
        : Optional[zio.aws.codedeploy.model.LambdaTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaTarget())
        .map(value => zio.aws.codedeploy.model.LambdaTarget.wrap(value))
    override val ecsTarget
        : Optional[zio.aws.codedeploy.model.ECSTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecsTarget())
        .map(value => zio.aws.codedeploy.model.ECSTarget.wrap(value))
    override val cloudFormationTarget
        : Optional[zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudFormationTarget())
        .map(value => zio.aws.codedeploy.model.CloudFormationTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentTarget
  ): zio.aws.codedeploy.model.DeploymentTarget.ReadOnly = new Wrapper(impl)
}
