package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.InstanceName
import scala.jdk.CollectionConverters._
final case class BatchGetOnPremisesInstancesRequest(
    instanceNames: Iterable[InstanceName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest = {
    import BatchGetOnPremisesInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest
      .builder()
      .instanceNames(instanceNames.map { item =>
        InstanceName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetOnPremisesInstancesRequest.ReadOnly =
    zio.aws.codedeploy.model.BatchGetOnPremisesInstancesRequest
      .wrap(buildAwsValue())
}
object BatchGetOnPremisesInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.BatchGetOnPremisesInstancesRequest =
      zio.aws.codedeploy.model.BatchGetOnPremisesInstancesRequest(instanceNames)
    def instanceNames: List[InstanceName]
    def getInstanceNames: ZIO[Any, Nothing, List[InstanceName]] =
      ZIO.succeed(instanceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest
  ) extends zio.aws.codedeploy.model.BatchGetOnPremisesInstancesRequest.ReadOnly {
    override val instanceNames: List[InstanceName] = impl
      .instanceNames()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.InstanceName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest
  ): zio.aws.codedeploy.model.BatchGetOnPremisesInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
