package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ApplicationName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetApplicationRevisionResponse(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    revision: Optional[zio.aws.codedeploy.model.RevisionLocation] =
      Optional.Absent,
    revisionInfo: Optional[zio.aws.codedeploy.model.GenericRevisionInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse = {
    import GetApplicationRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(revision.map(value => value.buildAwsValue()))(_.revision)
      .optionallyWith(revisionInfo.map(value => value.buildAwsValue()))(
        _.revisionInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly =
    zio.aws.codedeploy.model.GetApplicationRevisionResponse
      .wrap(buildAwsValue())
}
object GetApplicationRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetApplicationRevisionResponse =
      zio.aws.codedeploy.model.GetApplicationRevisionResponse(
        applicationName.map(value => value),
        revision.map(value => value.asEditable),
        revisionInfo.map(value => value.asEditable)
      )
    def applicationName: Optional[ApplicationName]
    def revision: Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def revisionInfo
        : Optional[zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("revision", revision)
    def getRevisionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly
    ] = AwsError.unwrapOptionField("revisionInfo", revisionInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse
  ) extends zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.ApplicationName(value)
        )
    override val revision
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revision())
        .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val revisionInfo
        : Optional[zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionInfo())
        .map(value => zio.aws.codedeploy.model.GenericRevisionInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse
  ): zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly =
    new Wrapper(impl)
}
