package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancerInfo(
    elbInfoList: Option[Iterable[zio.aws.codedeploy.model.ELBInfo]] = None,
    targetGroupInfoList: Option[
      Iterable[zio.aws.codedeploy.model.TargetGroupInfo]
    ] = None,
    targetGroupPairInfoList: Option[
      Iterable[zio.aws.codedeploy.model.TargetGroupPairInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo = {
    import LoadBalancerInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo
      .builder()
      .optionallyWith(
        elbInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elbInfoList)
      .optionallyWith(
        targetGroupInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroupInfoList)
      .optionallyWith(
        targetGroupPairInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroupPairInfoList)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly =
    zio.aws.codedeploy.model.LoadBalancerInfo.wrap(buildAwsValue())
}
object LoadBalancerInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LoadBalancerInfo =
      zio.aws.codedeploy.model.LoadBalancerInfo(
        elbInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetGroupInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetGroupPairInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def elbInfoList: Option[List[zio.aws.codedeploy.model.ELBInfo.ReadOnly]]
    def targetGroupInfoList
        : Option[List[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]]
    def targetGroupPairInfoList
        : Option[List[zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly]]
    def getElbInfoList
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.ELBInfo.ReadOnly]] =
      AwsError.unwrapOptionField("elbInfoList", elbInfoList)
    def getTargetGroupInfoList: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroupInfoList", targetGroupInfoList)
    def getTargetGroupPairInfoList: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetGroupPairInfoList",
      targetGroupPairInfoList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo
  ) extends zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly {
    override val elbInfoList
        : Option[List[zio.aws.codedeploy.model.ELBInfo.ReadOnly]] = scala
      .Option(impl.elbInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.ELBInfo.wrap(item)
        }.toList
      )
    override val targetGroupInfoList
        : Option[List[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]] =
      scala
        .Option(impl.targetGroupInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TargetGroupInfo.wrap(item)
          }.toList
        )
    override val targetGroupPairInfoList
        : Option[List[zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly]] =
      scala
        .Option(impl.targetGroupPairInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TargetGroupPairInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo
  ): zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly = new Wrapper(impl)
}
