package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  NextToken,
  ExternalId,
  DeploymentGroupName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class ListDeploymentsRequest(
    applicationName: Option[ApplicationName] = None,
    deploymentGroupName: Option[DeploymentGroupName] = None,
    externalId: Option[ExternalId] = None,
    includeOnlyStatuses: Option[
      Iterable[zio.aws.codedeploy.model.DeploymentStatus]
    ] = None,
    createTimeRange: Option[zio.aws.codedeploy.model.TimeRange] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest = {
    import ListDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        deploymentGroupName.map(value =>
          DeploymentGroupName.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupName)
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        includeOnlyStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeOnlyStatusesWithStrings)
      .optionallyWith(createTimeRange.map(value => value.buildAwsValue()))(
        _.createTimeRange
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ListDeploymentsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentsRequest.wrap(buildAwsValue())
}
object ListDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentsRequest =
      zio.aws.codedeploy.model.ListDeploymentsRequest(
        applicationName.map(value => value),
        deploymentGroupName.map(value => value),
        externalId.map(value => value),
        includeOnlyStatuses.map(value => value),
        createTimeRange.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def deploymentGroupName: Option[DeploymentGroupName]
    def externalId: Option[ExternalId]
    def includeOnlyStatuses
        : Option[List[zio.aws.codedeploy.model.DeploymentStatus]]
    def createTimeRange: Option[zio.aws.codedeploy.model.TimeRange.ReadOnly]
    def nextToken: Option[NextToken]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDeploymentGroupName: ZIO[Any, AwsError, DeploymentGroupName] =
      AwsError.unwrapOptionField("deploymentGroupName", deploymentGroupName)
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getIncludeOnlyStatuses
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.DeploymentStatus]] =
      AwsError.unwrapOptionField("includeOnlyStatuses", includeOnlyStatuses)
    def getCreateTimeRange
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TimeRange.ReadOnly] =
      AwsError.unwrapOptionField("createTimeRange", createTimeRange)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest
  ) extends zio.aws.codedeploy.model.ListDeploymentsRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationName(value))
    override val deploymentGroupName: Option[DeploymentGroupName] = scala
      .Option(impl.deploymentGroupName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentGroupName(value)
      )
    override val externalId: Option[ExternalId] = scala
      .Option(impl.externalId())
      .map(value => zio.aws.codedeploy.model.primitives.ExternalId(value))
    override val includeOnlyStatuses
        : Option[List[zio.aws.codedeploy.model.DeploymentStatus]] = scala
      .Option(impl.includeOnlyStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.DeploymentStatus.wrap(item)
        }.toList
      )
    override val createTimeRange
        : Option[zio.aws.codedeploy.model.TimeRange.ReadOnly] = scala
      .Option(impl.createTimeRange())
      .map(value => zio.aws.codedeploy.model.TimeRange.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest
  ): zio.aws.codedeploy.model.ListDeploymentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
