package zio.aws.codedeploy.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.Duration
import scala.jdk.CollectionConverters._
final case class BlueInstanceTerminationOption(
    action: Option[zio.aws.codedeploy.model.InstanceAction] = None,
    terminationWaitTimeInMinutes: Option[Duration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption = {
    import BlueInstanceTerminationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        terminationWaitTimeInMinutes.map(value =>
          Duration.unwrap(value): Integer
        )
      )(_.terminationWaitTimeInMinutes)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly =
    zio.aws.codedeploy.model.BlueInstanceTerminationOption.wrap(buildAwsValue())
}
object BlueInstanceTerminationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BlueInstanceTerminationOption =
      zio.aws.codedeploy.model.BlueInstanceTerminationOption(
        action.map(value => value),
        terminationWaitTimeInMinutes.map(value => value)
      )
    def action: Option[zio.aws.codedeploy.model.InstanceAction]
    def terminationWaitTimeInMinutes: Option[Duration]
    def getAction: ZIO[Any, AwsError, zio.aws.codedeploy.model.InstanceAction] =
      AwsError.unwrapOptionField("action", action)
    def getTerminationWaitTimeInMinutes: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField(
        "terminationWaitTimeInMinutes",
        terminationWaitTimeInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
  ) extends zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly {
    override val action: Option[zio.aws.codedeploy.model.InstanceAction] = scala
      .Option(impl.action())
      .map(value => zio.aws.codedeploy.model.InstanceAction.wrap(value))
    override val terminationWaitTimeInMinutes: Option[Duration] = scala
      .Option(impl.terminationWaitTimeInMinutes())
      .map(value => zio.aws.codedeploy.model.primitives.Duration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
  ): zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly =
    new Wrapper(impl)
}
