package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrafficRoutingConfig(
    `type`: Option[zio.aws.codedeploy.model.TrafficRoutingType] = None,
    timeBasedCanary: Option[zio.aws.codedeploy.model.TimeBasedCanary] = None,
    timeBasedLinear: Option[zio.aws.codedeploy.model.TimeBasedLinear] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig = {
    import TrafficRoutingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(timeBasedCanary.map(value => value.buildAwsValue()))(
        _.timeBasedCanary
      )
      .optionallyWith(timeBasedLinear.map(value => value.buildAwsValue()))(
        _.timeBasedLinear
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly =
    zio.aws.codedeploy.model.TrafficRoutingConfig.wrap(buildAwsValue())
}
object TrafficRoutingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TrafficRoutingConfig =
      zio.aws.codedeploy.model.TrafficRoutingConfig(
        `type`.map(value => value),
        timeBasedCanary.map(value => value.asEditable),
        timeBasedLinear.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.codedeploy.model.TrafficRoutingType]
    def timeBasedCanary
        : Option[zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly]
    def timeBasedLinear
        : Option[zio.aws.codedeploy.model.TimeBasedLinear.ReadOnly]
    def getType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TrafficRoutingType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTimeBasedCanary: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly
    ] = AwsError.unwrapOptionField("timeBasedCanary", timeBasedCanary)
    def getTimeBasedLinear: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TimeBasedLinear.ReadOnly
    ] = AwsError.unwrapOptionField("timeBasedLinear", timeBasedLinear)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig
  ) extends zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly {
    override val `type`: Option[zio.aws.codedeploy.model.TrafficRoutingType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.codedeploy.model.TrafficRoutingType.wrap(value))
    override val timeBasedCanary
        : Option[zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly] = scala
      .Option(impl.timeBasedCanary())
      .map(value => zio.aws.codedeploy.model.TimeBasedCanary.wrap(value))
    override val timeBasedLinear
        : Option[zio.aws.codedeploy.model.TimeBasedLinear.ReadOnly] = scala
      .Option(impl.timeBasedLinear())
      .map(value => zio.aws.codedeploy.model.TimeBasedLinear.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig
  ): zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly = new Wrapper(impl)
}
