package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait TargetLabel {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.TargetLabel
}
object TargetLabel {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.TargetLabel
  ): zio.aws.codedeploy.model.TargetLabel = value match {
    case software.amazon.awssdk.services.codedeploy.model.TargetLabel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetLabel.BLUE =>
      val r = Blue
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetLabel.GREEN =>
      val r = Green
      r
  }
  case object unknownToSdkVersion extends zio.aws.codedeploy.model.TargetLabel {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetLabel =
      software.amazon.awssdk.services.codedeploy.model.TargetLabel.UNKNOWN_TO_SDK_VERSION
  }
  case object Blue extends zio.aws.codedeploy.model.TargetLabel {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetLabel =
      software.amazon.awssdk.services.codedeploy.model.TargetLabel.BLUE
  }
  case object Green extends zio.aws.codedeploy.model.TargetLabel {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetLabel =
      software.amazon.awssdk.services.codedeploy.model.TargetLabel.GREEN
  }
}
