package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ELBName
import scala.jdk.CollectionConverters._
final case class ELBInfo(name: Option[ELBName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ELBInfo = {
    import ELBInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ELBInfo
      .builder()
      .optionallyWith(
        name.map(value => ELBName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ELBInfo.ReadOnly =
    zio.aws.codedeploy.model.ELBInfo.wrap(buildAwsValue())
}
object ELBInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ELBInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ELBInfo =
      zio.aws.codedeploy.model.ELBInfo(name.map(value => value))
    def name: Option[ELBName]
    def getName: ZIO[Any, AwsError, ELBName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ELBInfo
  ) extends zio.aws.codedeploy.model.ELBInfo.ReadOnly {
    override val name: Option[ELBName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codedeploy.model.primitives.ELBName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ELBInfo
  ): zio.aws.codedeploy.model.ELBInfo.ReadOnly = new Wrapper(impl)
}
