package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentId
import scala.jdk.CollectionConverters._
final case class CreateDeploymentResponse(
    deploymentId: Option[DeploymentId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse = {
    import CreateDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly =
    zio.aws.codedeploy.model.CreateDeploymentResponse.wrap(buildAwsValue())
}
object CreateDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateDeploymentResponse =
      zio.aws.codedeploy.model
        .CreateDeploymentResponse(deploymentId.map(value => value))
    def deploymentId: Option[DeploymentId]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse
  ) extends zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse
  ): zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
