package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ApplicationName
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationName: Option[ApplicationName] = None,
    newApplicationName: Option[ApplicationName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        newApplicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.newApplicationName)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.codedeploy.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.UpdateApplicationRequest =
      zio.aws.codedeploy.model.UpdateApplicationRequest(
        applicationName.map(value => value),
        newApplicationName.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def newApplicationName: Option[ApplicationName]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getNewApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("newApplicationName", newApplicationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest
  ) extends zio.aws.codedeploy.model.UpdateApplicationRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationName(value))
    override val newApplicationName: Option[ApplicationName] = scala
      .Option(impl.newApplicationName())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest
  ): zio.aws.codedeploy.model.UpdateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
