package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  FilterValue,
  NextToken,
  DeploymentId
}
import scala.jdk.CollectionConverters._
final case class ListDeploymentTargetsRequest(
    deploymentId: Option[DeploymentId] = None,
    nextToken: Option[NextToken] = None,
    targetFilters: Option[
      Map[zio.aws.codedeploy.model.TargetFilterName, Iterable[FilterValue]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest = {
    import ListDeploymentTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        targetFilters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                FilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.targetFiltersWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentTargetsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentTargetsRequest.wrap(buildAwsValue())
}
object ListDeploymentTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentTargetsRequest =
      zio.aws.codedeploy.model.ListDeploymentTargetsRequest(
        deploymentId.map(value => value),
        nextToken.map(value => value),
        targetFilters.map(value => value)
      )
    def deploymentId: Option[DeploymentId]
    def nextToken: Option[NextToken]
    def targetFilters: Option[
      Map[zio.aws.codedeploy.model.TargetFilterName, List[FilterValue]]
    ]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTargetFilters: ZIO[Any, AwsError, Map[
      zio.aws.codedeploy.model.TargetFilterName,
      List[FilterValue]
    ]] = AwsError.unwrapOptionField("targetFilters", targetFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
  ) extends zio.aws.codedeploy.model.ListDeploymentTargetsRequest.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
    override val targetFilters: Option[
      Map[zio.aws.codedeploy.model.TargetFilterName, List[FilterValue]]
    ] = scala
      .Option(impl.targetFilters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codedeploy.model.TargetFilterName
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.codedeploy.model.primitives.FilterValue(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
  ): zio.aws.codedeploy.model.ListDeploymentTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
