package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentReadyAction {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction
}
object DeploymentReadyAction {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction
  ): zio.aws.codedeploy.model.DeploymentReadyAction = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction.CONTINUE_DEPLOYMENT =>
      val r = CONTINUE_DEPLOYMENT
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction.STOP_DEPLOYMENT =>
      val r = STOP_DEPLOYMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentReadyAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction =
      software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUE_DEPLOYMENT
      extends zio.aws.codedeploy.model.DeploymentReadyAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction =
      software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction.CONTINUE_DEPLOYMENT
  }
  case object STOP_DEPLOYMENT
      extends zio.aws.codedeploy.model.DeploymentReadyAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction =
      software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction.STOP_DEPLOYMENT
  }
}
