package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AlarmConfiguration(
    enabled: Option[Boolean] = None,
    ignorePollAlarmFailure: Option[Boolean] = None,
    alarms: Option[Iterable[zio.aws.codedeploy.model.Alarm]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration = {
    import AlarmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        ignorePollAlarmFailure.map(value => value: java.lang.Boolean)
      )(_.ignorePollAlarmFailure)
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly =
    zio.aws.codedeploy.model.AlarmConfiguration.wrap(buildAwsValue())
}
object AlarmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.AlarmConfiguration =
      zio.aws.codedeploy.model.AlarmConfiguration(
        enabled.map(value => value),
        ignorePollAlarmFailure.map(value => value),
        alarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Option[Boolean]
    def ignorePollAlarmFailure: Option[Boolean]
    def alarms: Option[List[zio.aws.codedeploy.model.Alarm.ReadOnly]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIgnorePollAlarmFailure: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("ignorePollAlarmFailure", ignorePollAlarmFailure)
    def getAlarms
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.Alarm.ReadOnly]] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
  ) extends zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val ignorePollAlarmFailure: Option[Boolean] =
      scala.Option(impl.ignorePollAlarmFailure()).map(value => value: Boolean)
    override val alarms: Option[List[zio.aws.codedeploy.model.Alarm.ReadOnly]] =
      scala
        .Option(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.Alarm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration
  ): zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly = new Wrapper(impl)
}
