package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, TargetId}
import scala.jdk.CollectionConverters._
final case class ListDeploymentTargetsResponse(
    targetIds: Option[Iterable[TargetId]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse = {
    import ListDeploymentTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
      .builder()
      .optionallyWith(
        targetIds.map(value =>
          value.map { item =>
            TargetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentTargetsResponse.wrap(buildAwsValue())
}
object ListDeploymentTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentTargetsResponse =
      zio.aws.codedeploy.model.ListDeploymentTargetsResponse(
        targetIds.map(value => value),
        nextToken.map(value => value)
      )
    def targetIds: Option[List[TargetId]]
    def nextToken: Option[NextToken]
    def getTargetIds: ZIO[Any, AwsError, List[TargetId]] =
      AwsError.unwrapOptionField("targetIds", targetIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
  ) extends zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly {
    override val targetIds: Option[List[TargetId]] = scala
      .Option(impl.targetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.primitives.TargetId(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
  ): zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
