package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryTriggerName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestRepositoryTriggersResponse(
    successfulExecutions: Optional[Iterable[RepositoryTriggerName]] =
      Optional.Absent,
    failedExecutions: Optional[
      Iterable[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse = {
    import TestRepositoryTriggersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
      .builder()
      .optionallyWith(
        successfulExecutions.map(value =>
          value.map { item =>
            RepositoryTriggerName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.successfulExecutions)
      .optionallyWith(
        failedExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedExecutions)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly =
    zio.aws.codecommit.model.TestRepositoryTriggersResponse
      .wrap(buildAwsValue())
}
object TestRepositoryTriggersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.TestRepositoryTriggersResponse =
      zio.aws.codecommit.model.TestRepositoryTriggersResponse(
        successfulExecutions.map(value => value),
        failedExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulExecutions: Optional[List[RepositoryTriggerName]]
    def failedExecutions: Optional[
      List[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly]
    ]
    def getSuccessfulExecutions
        : ZIO[Any, AwsError, List[RepositoryTriggerName]] =
      AwsError.unwrapOptionField("successfulExecutions", successfulExecutions)
    def getFailedExecutions: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failedExecutions", failedExecutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
  ) extends zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly {
    override val successfulExecutions: Optional[List[RepositoryTriggerName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successfulExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.RepositoryTriggerName(item)
          }.toList
        )
    override val failedExecutions: Optional[
      List[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
  ): zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly =
    new Wrapper(impl)
}
