package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ReactionUnicode,
  ReactionShortCode,
  ReactionEmoji
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReactionValueFormats(
    emoji: Optional[ReactionEmoji] = Optional.Absent,
    shortCode: Optional[ReactionShortCode] = Optional.Absent,
    unicode: Optional[ReactionUnicode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ReactionValueFormats = {
    import ReactionValueFormats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
      .builder()
      .optionallyWith(
        emoji.map(value => ReactionEmoji.unwrap(value): java.lang.String)
      )(_.emoji)
      .optionallyWith(
        shortCode.map(value =>
          ReactionShortCode.unwrap(value): java.lang.String
        )
      )(_.shortCode)
      .optionallyWith(
        unicode.map(value => ReactionUnicode.unwrap(value): java.lang.String)
      )(_.unicode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ReactionValueFormats.ReadOnly =
    zio.aws.codecommit.model.ReactionValueFormats.wrap(buildAwsValue())
}
object ReactionValueFormats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ReactionValueFormats =
      zio.aws.codecommit.model.ReactionValueFormats(
        emoji.map(value => value),
        shortCode.map(value => value),
        unicode.map(value => value)
      )
    def emoji: Optional[ReactionEmoji]
    def shortCode: Optional[ReactionShortCode]
    def unicode: Optional[ReactionUnicode]
    def getEmoji: ZIO[Any, AwsError, ReactionEmoji] =
      AwsError.unwrapOptionField("emoji", emoji)
    def getShortCode: ZIO[Any, AwsError, ReactionShortCode] =
      AwsError.unwrapOptionField("shortCode", shortCode)
    def getUnicode: ZIO[Any, AwsError, ReactionUnicode] =
      AwsError.unwrapOptionField("unicode", unicode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
  ) extends zio.aws.codecommit.model.ReactionValueFormats.ReadOnly {
    override val emoji: Optional[ReactionEmoji] = zio.aws.core.internal
      .optionalFromNullable(impl.emoji())
      .map(value => zio.aws.codecommit.model.primitives.ReactionEmoji(value))
    override val shortCode: Optional[ReactionShortCode] = zio.aws.core.internal
      .optionalFromNullable(impl.shortCode())
      .map(value =>
        zio.aws.codecommit.model.primitives.ReactionShortCode(value)
      )
    override val unicode: Optional[ReactionUnicode] = zio.aws.core.internal
      .optionalFromNullable(impl.unicode())
      .map(value => zio.aws.codecommit.model.primitives.ReactionUnicode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
  ): zio.aws.codecommit.model.ReactionValueFormats.ReadOnly = new Wrapper(impl)
}
