package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutFileResponse(
    commitId: ObjectId,
    blobId: ObjectId,
    treeId: ObjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PutFileResponse = {
    import PutFileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PutFileResponse
      .builder()
      .commitId(ObjectId.unwrap(commitId): java.lang.String)
      .blobId(ObjectId.unwrap(blobId): java.lang.String)
      .treeId(ObjectId.unwrap(treeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PutFileResponse.ReadOnly =
    zio.aws.codecommit.model.PutFileResponse.wrap(buildAwsValue())
}
object PutFileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PutFileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PutFileResponse =
      zio.aws.codecommit.model.PutFileResponse(commitId, blobId, treeId)
    def commitId: ObjectId
    def blobId: ObjectId
    def treeId: ObjectId
    def getCommitId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(commitId)
    def getBlobId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(blobId)
    def getTreeId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(treeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PutFileResponse
  ) extends zio.aws.codecommit.model.PutFileResponse.ReadOnly {
    override val commitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.commitId())
    override val blobId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.blobId())
    override val treeId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.treeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PutFileResponse
  ): zio.aws.codecommit.model.PutFileResponse.ReadOnly = new Wrapper(impl)
}
