package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  IsObjectTypeConflict,
  IsContentConflict,
  Path,
  IsFileModeConflict,
  NumberOfConflicts
}
import scala.jdk.CollectionConverters.*
final case class ConflictMetadata(
    filePath: Optional[Path] = Optional.Absent,
    fileSizes: Optional[zio.aws.codecommit.model.FileSizes] = Optional.Absent,
    fileModes: Optional[zio.aws.codecommit.model.FileModes] = Optional.Absent,
    objectTypes: Optional[zio.aws.codecommit.model.ObjectTypes] =
      Optional.Absent,
    numberOfConflicts: Optional[NumberOfConflicts] = Optional.Absent,
    isBinaryFile: Optional[zio.aws.codecommit.model.IsBinaryFile] =
      Optional.Absent,
    contentConflict: Optional[IsContentConflict] = Optional.Absent,
    fileModeConflict: Optional[IsFileModeConflict] = Optional.Absent,
    objectTypeConflict: Optional[IsObjectTypeConflict] = Optional.Absent,
    mergeOperations: Optional[zio.aws.codecommit.model.MergeOperations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ConflictMetadata = {
    import ConflictMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ConflictMetadata
      .builder()
      .optionallyWith(
        filePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(fileSizes.map(value => value.buildAwsValue()))(
        _.fileSizes
      )
      .optionallyWith(fileModes.map(value => value.buildAwsValue()))(
        _.fileModes
      )
      .optionallyWith(objectTypes.map(value => value.buildAwsValue()))(
        _.objectTypes
      )
      .optionallyWith(
        numberOfConflicts.map(value => NumberOfConflicts.unwrap(value): Integer)
      )(_.numberOfConflicts)
      .optionallyWith(isBinaryFile.map(value => value.buildAwsValue()))(
        _.isBinaryFile
      )
      .optionallyWith(
        contentConflict.map(value =>
          IsContentConflict.unwrap(value): java.lang.Boolean
        )
      )(_.contentConflict)
      .optionallyWith(
        fileModeConflict.map(value =>
          IsFileModeConflict.unwrap(value): java.lang.Boolean
        )
      )(_.fileModeConflict)
      .optionallyWith(
        objectTypeConflict.map(value =>
          IsObjectTypeConflict.unwrap(value): java.lang.Boolean
        )
      )(_.objectTypeConflict)
      .optionallyWith(mergeOperations.map(value => value.buildAwsValue()))(
        _.mergeOperations
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ConflictMetadata.ReadOnly =
    zio.aws.codecommit.model.ConflictMetadata.wrap(buildAwsValue())
}
object ConflictMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ConflictMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ConflictMetadata =
      zio.aws.codecommit.model.ConflictMetadata(
        filePath.map(value => value),
        fileSizes.map(value => value.asEditable),
        fileModes.map(value => value.asEditable),
        objectTypes.map(value => value.asEditable),
        numberOfConflicts.map(value => value),
        isBinaryFile.map(value => value.asEditable),
        contentConflict.map(value => value),
        fileModeConflict.map(value => value),
        objectTypeConflict.map(value => value),
        mergeOperations.map(value => value.asEditable)
      )
    def filePath: Optional[Path]
    def fileSizes: Optional[zio.aws.codecommit.model.FileSizes.ReadOnly]
    def fileModes: Optional[zio.aws.codecommit.model.FileModes.ReadOnly]
    def objectTypes: Optional[zio.aws.codecommit.model.ObjectTypes.ReadOnly]
    def numberOfConflicts: Optional[NumberOfConflicts]
    def isBinaryFile: Optional[zio.aws.codecommit.model.IsBinaryFile.ReadOnly]
    def contentConflict: Optional[IsContentConflict]
    def fileModeConflict: Optional[IsFileModeConflict]
    def objectTypeConflict: Optional[IsObjectTypeConflict]
    def mergeOperations
        : Optional[zio.aws.codecommit.model.MergeOperations.ReadOnly]
    def getFilePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFileSizes
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileSizes.ReadOnly] =
      AwsError.unwrapOptionField("fileSizes", fileSizes)
    def getFileModes
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModes.ReadOnly] =
      AwsError.unwrapOptionField("fileModes", fileModes)
    def getObjectTypes
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ObjectTypes.ReadOnly] =
      AwsError.unwrapOptionField("objectTypes", objectTypes)
    def getNumberOfConflicts: ZIO[Any, AwsError, NumberOfConflicts] =
      AwsError.unwrapOptionField("numberOfConflicts", numberOfConflicts)
    def getIsBinaryFile
        : ZIO[Any, AwsError, zio.aws.codecommit.model.IsBinaryFile.ReadOnly] =
      AwsError.unwrapOptionField("isBinaryFile", isBinaryFile)
    def getContentConflict: ZIO[Any, AwsError, IsContentConflict] =
      AwsError.unwrapOptionField("contentConflict", contentConflict)
    def getFileModeConflict: ZIO[Any, AwsError, IsFileModeConflict] =
      AwsError.unwrapOptionField("fileModeConflict", fileModeConflict)
    def getObjectTypeConflict: ZIO[Any, AwsError, IsObjectTypeConflict] =
      AwsError.unwrapOptionField("objectTypeConflict", objectTypeConflict)
    def getMergeOperations: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.MergeOperations.ReadOnly
    ] = AwsError.unwrapOptionField("mergeOperations", mergeOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ConflictMetadata
  ) extends zio.aws.codecommit.model.ConflictMetadata.ReadOnly {
    override val filePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val fileSizes
        : Optional[zio.aws.codecommit.model.FileSizes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSizes())
        .map(value => zio.aws.codecommit.model.FileSizes.wrap(value))
    override val fileModes
        : Optional[zio.aws.codecommit.model.FileModes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileModes())
        .map(value => zio.aws.codecommit.model.FileModes.wrap(value))
    override val objectTypes
        : Optional[zio.aws.codecommit.model.ObjectTypes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectTypes())
        .map(value => zio.aws.codecommit.model.ObjectTypes.wrap(value))
    override val numberOfConflicts: Optional[NumberOfConflicts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfConflicts())
        .map(value =>
          zio.aws.codecommit.model.primitives.NumberOfConflicts(value)
        )
    override val isBinaryFile
        : Optional[zio.aws.codecommit.model.IsBinaryFile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isBinaryFile())
        .map(value => zio.aws.codecommit.model.IsBinaryFile.wrap(value))
    override val contentConflict: Optional[IsContentConflict] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentConflict())
        .map(value =>
          zio.aws.codecommit.model.primitives.IsContentConflict(value)
        )
    override val fileModeConflict: Optional[IsFileModeConflict] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileModeConflict())
        .map(value =>
          zio.aws.codecommit.model.primitives.IsFileModeConflict(value)
        )
    override val objectTypeConflict: Optional[IsObjectTypeConflict] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectTypeConflict())
        .map(value =>
          zio.aws.codecommit.model.primitives.IsObjectTypeConflict(value)
        )
    override val mergeOperations
        : Optional[zio.aws.codecommit.model.MergeOperations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergeOperations())
        .map(value => zio.aws.codecommit.model.MergeOperations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ConflictMetadata
  ): zio.aws.codecommit.model.ConflictMetadata.ReadOnly = new Wrapper(impl)
}
