package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateApprovalRuleTemplateNameRequest(
    oldApprovalRuleTemplateName: ApprovalRuleTemplateName,
    newApprovalRuleTemplateName: ApprovalRuleTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest = {
    import UpdateApprovalRuleTemplateNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest
      .builder()
      .oldApprovalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          oldApprovalRuleTemplateName
        ): java.lang.String
      )
      .newApprovalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          newApprovalRuleTemplateName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest
      .wrap(buildAwsValue())
}
object UpdateApprovalRuleTemplateNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest =
      zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest(
        oldApprovalRuleTemplateName,
        newApprovalRuleTemplateName
      )
    def oldApprovalRuleTemplateName: ApprovalRuleTemplateName
    def newApprovalRuleTemplateName: ApprovalRuleTemplateName
    def getOldApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(oldApprovalRuleTemplateName)
    def getNewApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(newApprovalRuleTemplateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest
  ) extends zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest.ReadOnly {
    override val oldApprovalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.oldApprovalRuleTemplateName())
    override val newApprovalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.newApprovalRuleTemplateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest
  ): zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest.ReadOnly =
    new Wrapper(impl)
}
