package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Description, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdatePullRequestDescriptionRequest(
    pullRequestId: PullRequestId,
    description: Description
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest = {
    import UpdatePullRequestDescriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .description(Description.unwrap(description): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest.ReadOnly =
    zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest
      .wrap(buildAwsValue())
}
object UpdatePullRequestDescriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest =
      zio.aws.codecommit.model
        .UpdatePullRequestDescriptionRequest(pullRequestId, description)
    def pullRequestId: PullRequestId
    def description: Description
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest
  ) extends zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val description: Description =
      zio.aws.codecommit.model.primitives.Description(impl.description())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest
  ): zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest.ReadOnly =
    new Wrapper(impl)
}
