package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCommentsForPullRequestResponse(
    commentsForPullRequestData: Optional[
      Iterable[zio.aws.codecommit.model.CommentsForPullRequest]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse = {
    import GetCommentsForPullRequestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse
      .builder()
      .optionallyWith(
        commentsForPullRequestData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commentsForPullRequestData)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly =
    zio.aws.codecommit.model.GetCommentsForPullRequestResponse
      .wrap(buildAwsValue())
}
object GetCommentsForPullRequestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommentsForPullRequestResponse =
      zio.aws.codecommit.model.GetCommentsForPullRequestResponse(
        commentsForPullRequestData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def commentsForPullRequestData: Optional[
      List[zio.aws.codecommit.model.CommentsForPullRequest.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCommentsForPullRequestData: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.CommentsForPullRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "commentsForPullRequestData",
      commentsForPullRequestData
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse
  ) extends zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly {
    override val commentsForPullRequestData: Optional[
      List[zio.aws.codecommit.model.CommentsForPullRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commentsForPullRequestData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.CommentsForPullRequest.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse
  ): zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly =
    new Wrapper(impl)
}
