package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse(
    disassociatedRepositoryNames: Iterable[RepositoryName],
    errors: Iterable[
      zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse = {
    import BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
      .builder()
      .disassociatedRepositoryNames(disassociatedRepositoryNames.map { item =>
        RepositoryName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly =
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
      .wrap(buildAwsValue())
}
object BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse =
      zio.aws.codecommit.model
        .BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse(
          disassociatedRepositoryNames,
          errors.map { item =>
            item.asEditable
          }
        )
    def disassociatedRepositoryNames: List[RepositoryName]
    def errors: List[
      zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly
    ]
    def getDisassociatedRepositoryNames
        : ZIO[Any, Nothing, List[RepositoryName]] =
      ZIO.succeed(disassociatedRepositoryNames)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
  ) extends zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly {
    override val disassociatedRepositoryNames: List[RepositoryName] = impl
      .disassociatedRepositoryNames()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.primitives.RepositoryName(item)
      }
      .toList
    override val errors: List[
      zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
  ): zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly =
    new Wrapper(impl)
}
