package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait RepositoryTriggerEventEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum
}
object RepositoryTriggerEventEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum
  ): zio.aws.codecommit.model.RepositoryTriggerEventEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.ALL =>
      val r = all
      r
    case software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.UPDATE_REFERENCE =>
      val r = updateReference
      r
    case software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.CREATE_REFERENCE =>
      val r = createReference
      r
    case software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.DELETE_REFERENCE =>
      val r = deleteReference
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.RepositoryTriggerEventEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum =
      software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object all extends zio.aws.codecommit.model.RepositoryTriggerEventEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum =
      software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.ALL
  }
  case object updateReference
      extends zio.aws.codecommit.model.RepositoryTriggerEventEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum =
      software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.UPDATE_REFERENCE
  }
  case object createReference
      extends zio.aws.codecommit.model.RepositoryTriggerEventEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum =
      software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.CREATE_REFERENCE
  }
  case object deleteReference
      extends zio.aws.codecommit.model.RepositoryTriggerEventEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum =
      software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum.DELETE_REFERENCE
  }
}
