package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, CommitId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PostCommentForComparedCommitResponse(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    beforeCommitId: Optional[CommitId] = Optional.Absent,
    afterCommitId: Optional[CommitId] = Optional.Absent,
    beforeBlobId: Optional[ObjectId] = Optional.Absent,
    afterBlobId: Optional[ObjectId] = Optional.Absent,
    location: Optional[zio.aws.codecommit.model.Location] = Optional.Absent,
    comment: Optional[zio.aws.codecommit.model.Comment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse = {
    import PostCommentForComparedCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        beforeBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.beforeBlobId)
      .optionallyWith(
        afterBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.afterBlobId)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly =
    zio.aws.codecommit.model.PostCommentForComparedCommitResponse
      .wrap(buildAwsValue())
}
object PostCommentForComparedCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PostCommentForComparedCommitResponse =
      zio.aws.codecommit.model.PostCommentForComparedCommitResponse(
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        beforeBlobId.map(value => value),
        afterBlobId.map(value => value),
        location.map(value => value.asEditable),
        comment.map(value => value.asEditable)
      )
    def repositoryName: Optional[RepositoryName]
    def beforeCommitId: Optional[CommitId]
    def afterCommitId: Optional[CommitId]
    def beforeBlobId: Optional[ObjectId]
    def afterBlobId: Optional[ObjectId]
    def location: Optional[zio.aws.codecommit.model.Location.ReadOnly]
    def comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getBeforeBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("beforeBlobId", beforeBlobId)
    def getAfterBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("afterBlobId", afterBlobId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
  ) extends zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val beforeBlobId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val afterBlobId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.afterBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val location
        : Optional[zio.aws.codecommit.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
  ): zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly =
    new Wrapper(impl)
}
