package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleTemplateName,
  ApprovalRuleTemplateId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OriginApprovalRuleTemplate(
    approvalRuleTemplateId: Optional[ApprovalRuleTemplateId] = Optional.Absent,
    approvalRuleTemplateName: Optional[ApprovalRuleTemplateName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.OriginApprovalRuleTemplate = {
    import OriginApprovalRuleTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.OriginApprovalRuleTemplate
      .builder()
      .optionallyWith(
        approvalRuleTemplateId.map(value =>
          ApprovalRuleTemplateId.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateId)
      .optionallyWith(
        approvalRuleTemplateName.map(value =>
          ApprovalRuleTemplateName.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateName)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.OriginApprovalRuleTemplate.ReadOnly =
    zio.aws.codecommit.model.OriginApprovalRuleTemplate.wrap(buildAwsValue())
}
object OriginApprovalRuleTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.OriginApprovalRuleTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.OriginApprovalRuleTemplate =
      zio.aws.codecommit.model.OriginApprovalRuleTemplate(
        approvalRuleTemplateId.map(value => value),
        approvalRuleTemplateName.map(value => value)
      )
    def approvalRuleTemplateId: Optional[ApprovalRuleTemplateId]
    def approvalRuleTemplateName: Optional[ApprovalRuleTemplateName]
    def getApprovalRuleTemplateId: ZIO[Any, AwsError, ApprovalRuleTemplateId] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateId",
        approvalRuleTemplateId
      )
    def getApprovalRuleTemplateName
        : ZIO[Any, AwsError, ApprovalRuleTemplateName] = AwsError
      .unwrapOptionField("approvalRuleTemplateName", approvalRuleTemplateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.OriginApprovalRuleTemplate
  ) extends zio.aws.codecommit.model.OriginApprovalRuleTemplate.ReadOnly {
    override val approvalRuleTemplateId: Optional[ApprovalRuleTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleTemplateId())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateId(value)
        )
    override val approvalRuleTemplateName: Optional[ApprovalRuleTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleTemplateName())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.OriginApprovalRuleTemplate
  ): zio.aws.codecommit.model.OriginApprovalRuleTemplate.ReadOnly = new Wrapper(
    impl
  )
}
