package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  Arn,
  CommentId
}
import scala.jdk.CollectionConverters.*
final case class GetCommentReactionsRequest(
    commentId: CommentId,
    reactionUserArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest = {
    import GetCommentReactionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest
      .builder()
      .commentId(CommentId.unwrap(commentId): java.lang.String)
      .optionallyWith(
        reactionUserArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.reactionUserArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetCommentReactionsRequest.ReadOnly =
    zio.aws.codecommit.model.GetCommentReactionsRequest.wrap(buildAwsValue())
}
object GetCommentReactionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommentReactionsRequest =
      zio.aws.codecommit.model.GetCommentReactionsRequest(
        commentId,
        reactionUserArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def commentId: CommentId
    def reactionUserArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getCommentId: ZIO[Any, Nothing, CommentId] = ZIO.succeed(commentId)
    def getReactionUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("reactionUserArn", reactionUserArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest
  ) extends zio.aws.codecommit.model.GetCommentReactionsRequest.ReadOnly {
    override val commentId: CommentId =
      zio.aws.codecommit.model.primitives.CommentId(impl.commentId())
    override val reactionUserArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.reactionUserArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest
  ): zio.aws.codecommit.model.GetCommentReactionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
