package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCommentResponse(
    comment: Optional[zio.aws.codecommit.model.Comment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentResponse = {
    import GetCommentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentResponse
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetCommentResponse.ReadOnly =
    zio.aws.codecommit.model.GetCommentResponse.wrap(buildAwsValue())
}
object GetCommentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommentResponse =
      zio.aws.codecommit.model
        .GetCommentResponse(comment.map(value => value.asEditable))
    def comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly]
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentResponse
  ) extends zio.aws.codecommit.model.GetCommentResponse.ReadOnly {
    override val comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentResponse
  ): zio.aws.codecommit.model.GetCommentResponse.ReadOnly = new Wrapper(impl)
}
