package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RepositoryName, ObjectId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetCommitsRequest(
    commitIds: Iterable[ObjectId],
    repositoryName: RepositoryName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest = {
    import BatchGetCommitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest
      .builder()
      .commitIds(commitIds.map { item =>
        ObjectId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BatchGetCommitsRequest.ReadOnly =
    zio.aws.codecommit.model.BatchGetCommitsRequest.wrap(buildAwsValue())
}
object BatchGetCommitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetCommitsRequest =
      zio.aws.codecommit.model.BatchGetCommitsRequest(commitIds, repositoryName)
    def commitIds: List[ObjectId]
    def repositoryName: RepositoryName
    def getCommitIds: ZIO[Any, Nothing, List[ObjectId]] = ZIO.succeed(commitIds)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest
  ) extends zio.aws.codecommit.model.BatchGetCommitsRequest.ReadOnly {
    override val commitIds: List[ObjectId] = impl
      .commitIds()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.primitives.ObjectId(item)
      }
      .toList
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest
  ): zio.aws.codecommit.model.BatchGetCommitsRequest.ReadOnly = new Wrapper(
    impl
  )
}
