package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RepositoryName,
  ApprovalRuleTemplateName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateApprovalRuleTemplateWithRepositoryRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    repositoryName: RepositoryName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest = {
    import AssociateApprovalRuleTemplateWithRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest.ReadOnly =
    zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
      .wrap(buildAwsValue())
}
object AssociateApprovalRuleTemplateWithRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest =
      zio.aws.codecommit.model
        .AssociateApprovalRuleTemplateWithRepositoryRequest(
          approvalRuleTemplateName,
          repositoryName
        )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def repositoryName: RepositoryName
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
  ) extends zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
  ): zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest.ReadOnly =
    new Wrapper(impl)
}
