package zio.aws.codecommit
import zio.aws.codecommit.model.primitives.LastModifiedDate.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.codecommit.model.primitives.{
  RepositoryTriggerName,
  ApprovalRuleTemplateName,
  TagValue,
  Count,
  ReactionValue,
  RepositoryName,
  Arn,
  PullRequestId,
  Path,
  ObjectId,
  ApprovalRuleName,
  BranchName,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.codecommit.model.primitives.AccountId.Type
    object AdditionalData extends Subtype[String]
    type AdditionalData =
      zio.aws.codecommit.model.primitives.AdditionalData.Type
    object ApprovalRuleContent extends Subtype[String]
    type ApprovalRuleContent =
      zio.aws.codecommit.model.primitives.ApprovalRuleContent.Type
    object ApprovalRuleId extends Subtype[String]
    type ApprovalRuleId =
      zio.aws.codecommit.model.primitives.ApprovalRuleId.Type
    object ApprovalRuleName extends Subtype[String]
    type ApprovalRuleName =
      zio.aws.codecommit.model.primitives.ApprovalRuleName.Type
    object ApprovalRuleTemplateContent extends Subtype[String]
    type ApprovalRuleTemplateContent =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateContent.Type
    object ApprovalRuleTemplateDescription extends Subtype[String]
    type ApprovalRuleTemplateDescription =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateDescription.Type
    object ApprovalRuleTemplateId extends Subtype[String]
    type ApprovalRuleTemplateId =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateId.Type
    object ApprovalRuleTemplateName extends Subtype[String]
    type ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName.Type
    object Approved extends Subtype[Boolean]
    type Approved = zio.aws.codecommit.model.primitives.Approved.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.codecommit.model.primitives.Arn.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.codecommit.model.primitives.Blob.Type
    object BranchName extends Subtype[String]
    type BranchName = zio.aws.codecommit.model.primitives.BranchName.Type
    object CapitalBoolean extends Subtype[Boolean]
    type CapitalBoolean =
      zio.aws.codecommit.model.primitives.CapitalBoolean.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.codecommit.model.primitives.ClientRequestToken.Type
    object CloneUrlHttp extends Subtype[String]
    type CloneUrlHttp = zio.aws.codecommit.model.primitives.CloneUrlHttp.Type
    object CloneUrlSsh extends Subtype[String]
    type CloneUrlSsh = zio.aws.codecommit.model.primitives.CloneUrlSsh.Type
    object CommentId extends Subtype[String]
    type CommentId = zio.aws.codecommit.model.primitives.CommentId.Type
    object CommitId extends Subtype[String]
    type CommitId = zio.aws.codecommit.model.primitives.CommitId.Type
    object CommitName extends Subtype[String]
    type CommitName = zio.aws.codecommit.model.primitives.CommitName.Type
    object Content extends Subtype[String]
    type Content = zio.aws.codecommit.model.primitives.Content.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.codecommit.model.primitives.Count.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate = zio.aws.codecommit.model.primitives.CreationDate.Type
    object Date extends Subtype[String]
    type Date = zio.aws.codecommit.model.primitives.Date.Type
    object Description extends Subtype[String]
    type Description = zio.aws.codecommit.model.primitives.Description.Type
    object Email extends Subtype[String]
    type Email = zio.aws.codecommit.model.primitives.Email.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.codecommit.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.codecommit.model.primitives.ErrorMessage.Type
    object EventDate extends Subtype[Instant]
    type EventDate = zio.aws.codecommit.model.primitives.EventDate.Type
    object ExceptionName extends Subtype[String]
    type ExceptionName = zio.aws.codecommit.model.primitives.ExceptionName.Type
    object FileContent extends Subtype[Chunk[Byte]]
    type FileContent = zio.aws.codecommit.model.primitives.FileContent.Type
    object FileSize extends Subtype[Long]
    type FileSize = zio.aws.codecommit.model.primitives.FileSize.Type
    object HunkContent extends Subtype[String]
    type HunkContent = zio.aws.codecommit.model.primitives.HunkContent.Type
    object IsCommentDeleted extends Subtype[Boolean]
    type IsCommentDeleted =
      zio.aws.codecommit.model.primitives.IsCommentDeleted.Type
    object IsContentConflict extends Subtype[Boolean]
    type IsContentConflict =
      zio.aws.codecommit.model.primitives.IsContentConflict.Type
    object IsFileModeConflict extends Subtype[Boolean]
    type IsFileModeConflict =
      zio.aws.codecommit.model.primitives.IsFileModeConflict.Type
    object IsHunkConflict extends Subtype[Boolean]
    type IsHunkConflict =
      zio.aws.codecommit.model.primitives.IsHunkConflict.Type
    object IsMergeable extends Subtype[Boolean]
    type IsMergeable = zio.aws.codecommit.model.primitives.IsMergeable.Type
    object IsMerged extends Subtype[Boolean]
    type IsMerged = zio.aws.codecommit.model.primitives.IsMerged.Type
    object IsMove extends Subtype[Boolean]
    type IsMove = zio.aws.codecommit.model.primitives.IsMove.Type
    object IsObjectTypeConflict extends Subtype[Boolean]
    type IsObjectTypeConflict =
      zio.aws.codecommit.model.primitives.IsObjectTypeConflict.Type
    object KeepEmptyFolders extends Subtype[Boolean]
    type KeepEmptyFolders =
      zio.aws.codecommit.model.primitives.KeepEmptyFolders.Type
    object LastModifiedDate extends Subtype[Instant]
    type LastModifiedDate =
      zio.aws.codecommit.model.primitives.LastModifiedDate.Type
    object Limit extends Subtype[Int]
    type Limit = zio.aws.codecommit.model.primitives.Limit.Type
    object LineNumber extends Subtype[Int]
    type LineNumber = zio.aws.codecommit.model.primitives.LineNumber.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.codecommit.model.primitives.MaxResults.Type
    object Message extends Subtype[String]
    type Message = zio.aws.codecommit.model.primitives.Message.Type
    object Mode extends Subtype[String]
    type Mode = zio.aws.codecommit.model.primitives.Mode.Type
    object Name extends Subtype[String]
    type Name = zio.aws.codecommit.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.codecommit.model.primitives.NextToken.Type
    object NumberOfConflicts extends Subtype[Int]
    type NumberOfConflicts =
      zio.aws.codecommit.model.primitives.NumberOfConflicts.Type
    object ObjectId extends Subtype[String]
    type ObjectId = zio.aws.codecommit.model.primitives.ObjectId.Type
    object ObjectSize extends Subtype[Long]
    type ObjectSize = zio.aws.codecommit.model.primitives.ObjectSize.Type
    object Overridden extends Subtype[Boolean]
    type Overridden = zio.aws.codecommit.model.primitives.Overridden.Type
    object Path extends Subtype[String]
    type Path = zio.aws.codecommit.model.primitives.Path.Type
    object Position extends Subtype[Long]
    type Position = zio.aws.codecommit.model.primitives.Position.Type
    object PullRequestId extends Subtype[String]
    type PullRequestId = zio.aws.codecommit.model.primitives.PullRequestId.Type
    object ReactionEmoji extends Subtype[String]
    type ReactionEmoji = zio.aws.codecommit.model.primitives.ReactionEmoji.Type
    object ReactionShortCode extends Subtype[String]
    type ReactionShortCode =
      zio.aws.codecommit.model.primitives.ReactionShortCode.Type
    object ReactionUnicode extends Subtype[String]
    type ReactionUnicode =
      zio.aws.codecommit.model.primitives.ReactionUnicode.Type
    object ReactionValue extends Subtype[String]
    type ReactionValue = zio.aws.codecommit.model.primitives.ReactionValue.Type
    object ReferenceName extends Subtype[String]
    type ReferenceName = zio.aws.codecommit.model.primitives.ReferenceName.Type
    object RepositoryDescription extends Subtype[String]
    type RepositoryDescription =
      zio.aws.codecommit.model.primitives.RepositoryDescription.Type
    object RepositoryId extends Subtype[String]
    type RepositoryId = zio.aws.codecommit.model.primitives.RepositoryId.Type
    object RepositoryName extends Subtype[String]
    type RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName.Type
    object RepositoryTriggerCustomData extends Subtype[String]
    type RepositoryTriggerCustomData =
      zio.aws.codecommit.model.primitives.RepositoryTriggerCustomData.Type
    object RepositoryTriggerExecutionFailureMessage extends Subtype[String]
    type RepositoryTriggerExecutionFailureMessage =
      zio.aws.codecommit.model.primitives.RepositoryTriggerExecutionFailureMessage.Type
    object RepositoryTriggerName extends Subtype[String]
    type RepositoryTriggerName =
      zio.aws.codecommit.model.primitives.RepositoryTriggerName.Type
    object RepositoryTriggersConfigurationId extends Subtype[String]
    type RepositoryTriggersConfigurationId =
      zio.aws.codecommit.model.primitives.RepositoryTriggersConfigurationId.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.codecommit.model.primitives.ResourceArn.Type
    object RevisionId extends Subtype[String]
    type RevisionId = zio.aws.codecommit.model.primitives.RevisionId.Type
    object RuleContentSha256 extends Subtype[String]
    type RuleContentSha256 =
      zio.aws.codecommit.model.primitives.RuleContentSha256.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codecommit.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codecommit.model.primitives.TagValue.Type
    object Title extends Subtype[String]
    type Title = zio.aws.codecommit.model.primitives.Title.Type
  }
  type ApprovalList = List[zio.aws.codecommit.model.Approval]
  type ApprovalRuleTemplateNameList = List[ApprovalRuleTemplateName]
  type ApprovalRulesList = List[zio.aws.codecommit.model.ApprovalRule]
  type ApprovalRulesNotSatisfiedList = List[ApprovalRuleName]
  type ApprovalRulesSatisfiedList = List[ApprovalRuleName]
  type BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsList = List[
    zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError
  ]
  type BatchDescribeMergeConflictsErrors =
    List[zio.aws.codecommit.model.BatchDescribeMergeConflictsError]
  type BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsList = List[
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ]
  type BatchGetCommitsErrorsList =
    List[zio.aws.codecommit.model.BatchGetCommitsError]
  type BranchNameList = List[BranchName]
  type CallerReactions = List[ReactionValue]
  type Comments = List[zio.aws.codecommit.model.Comment]
  type CommentsForComparedCommitData =
    List[zio.aws.codecommit.model.CommentsForComparedCommit]
  type CommentsForPullRequestData =
    List[zio.aws.codecommit.model.CommentsForPullRequest]
  type CommitIdsInputList = List[ObjectId]
  type CommitObjectsList = List[zio.aws.codecommit.model.Commit]
  type ConflictMetadataList = List[zio.aws.codecommit.model.ConflictMetadata]
  type Conflicts = List[zio.aws.codecommit.model.Conflict]
  type DeleteFileEntries = List[zio.aws.codecommit.model.DeleteFileEntry]
  type DifferenceList = List[zio.aws.codecommit.model.Difference]
  type FileList = List[zio.aws.codecommit.model.File]
  type FilePaths = List[Path]
  type FilesMetadata = List[zio.aws.codecommit.model.FileMetadata]
  type FolderList = List[zio.aws.codecommit.model.Folder]
  type MergeHunks = List[zio.aws.codecommit.model.MergeHunk]
  type MergeOptions = List[zio.aws.codecommit.model.MergeOptionTypeEnum]
  type ParentList = List[ObjectId]
  type PullRequestEventList = List[zio.aws.codecommit.model.PullRequestEvent]
  type PullRequestIdList = List[PullRequestId]
  type PullRequestTargetList = List[zio.aws.codecommit.model.PullRequestTarget]
  type PutFileEntries = List[zio.aws.codecommit.model.PutFileEntry]
  type ReactionCountsMap = Map[ReactionValue, Count]
  type ReactionUsersList = List[Arn]
  type ReactionsForCommentList =
    List[zio.aws.codecommit.model.ReactionForComment]
  type ReplaceContentEntries =
    List[zio.aws.codecommit.model.ReplaceContentEntry]
  type RepositoryMetadataList =
    List[zio.aws.codecommit.model.RepositoryMetadata]
  type RepositoryNameIdPairList =
    List[zio.aws.codecommit.model.RepositoryNameIdPair]
  type RepositoryNameList = List[RepositoryName]
  type RepositoryNotFoundList = List[RepositoryName]
  type RepositoryTriggerEventList =
    List[zio.aws.codecommit.model.RepositoryTriggerEventEnum]
  type RepositoryTriggerExecutionFailureList =
    List[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure]
  type RepositoryTriggerNameList = List[RepositoryTriggerName]
  type RepositoryTriggersList = List[zio.aws.codecommit.model.RepositoryTrigger]
  type SetFileModeEntries = List[zio.aws.codecommit.model.SetFileModeEntry]
  type SubModuleList = List[zio.aws.codecommit.model.SubModule]
  type SymbolicLinkList = List[zio.aws.codecommit.model.SymbolicLink]
  type TagKeysList = List[TagKey]
  type TagsMap = Map[TagKey, TagValue]
  type TargetList = List[zio.aws.codecommit.model.Target]
}
