package zio.aws.codecommit.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecommit.model.primitives.{
  ClientRequestToken,
  RevisionId,
  Arn,
  PullRequestId,
  Description,
  LastModifiedDate,
  Title,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class PullRequest(
    pullRequestId: Optional[PullRequestId] = Optional.Absent,
    title: Optional[Title] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    lastActivityDate: Optional[LastModifiedDate] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    pullRequestStatus: Optional[
      zio.aws.codecommit.model.PullRequestStatusEnum
    ] = Optional.Absent,
    authorArn: Optional[Arn] = Optional.Absent,
    pullRequestTargets: Optional[
      Iterable[zio.aws.codecommit.model.PullRequestTarget]
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    revisionId: Optional[RevisionId] = Optional.Absent,
    approvalRules: Optional[Iterable[zio.aws.codecommit.model.ApprovalRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequest = {
    import PullRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequest
      .builder()
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        lastActivityDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastActivityDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(pullRequestStatus.map(value => value.unwrap))(
        _.pullRequestStatus
      )
      .optionallyWith(
        authorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.authorArn)
      .optionallyWith(
        pullRequestTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pullRequestTargets)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        approvalRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.approvalRules)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PullRequest.ReadOnly =
    zio.aws.codecommit.model.PullRequest.wrap(buildAwsValue())
}
object PullRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequest =
      zio.aws.codecommit.model.PullRequest(
        pullRequestId.map(value => value),
        title.map(value => value),
        description.map(value => value),
        lastActivityDate.map(value => value),
        creationDate.map(value => value),
        pullRequestStatus.map(value => value),
        authorArn.map(value => value),
        pullRequestTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        revisionId.map(value => value),
        approvalRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pullRequestId: Optional[PullRequestId]
    def title: Optional[Title]
    def description: Optional[Description]
    def lastActivityDate: Optional[LastModifiedDate]
    def creationDate: Optional[CreationDate]
    def pullRequestStatus
        : Optional[zio.aws.codecommit.model.PullRequestStatusEnum]
    def authorArn: Optional[Arn]
    def pullRequestTargets
        : Optional[List[zio.aws.codecommit.model.PullRequestTarget.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def revisionId: Optional[RevisionId]
    def approvalRules
        : Optional[List[zio.aws.codecommit.model.ApprovalRule.ReadOnly]]
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastActivityDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastActivityDate", lastActivityDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getPullRequestStatus
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestStatusEnum] =
      AwsError.unwrapOptionField("pullRequestStatus", pullRequestStatus)
    def getAuthorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("authorArn", authorArn)
    def getPullRequestTargets: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.PullRequestTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("pullRequestTargets", pullRequestTargets)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getApprovalRules: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.ApprovalRule.ReadOnly
    ]] = AwsError.unwrapOptionField("approvalRules", approvalRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequest
  ) extends zio.aws.codecommit.model.PullRequest.ReadOnly {
    override val pullRequestId: Optional[PullRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestId())
      .map(value => zio.aws.codecommit.model.primitives.PullRequestId(value))
    override val title: Optional[Title] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.codecommit.model.primitives.Title(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codecommit.model.primitives.Description(value))
    override val lastActivityDate: Optional[LastModifiedDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastActivityDate())
        .map(value =>
          zio.aws.codecommit.model.primitives.LastModifiedDate(value)
        )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val pullRequestStatus
        : Optional[zio.aws.codecommit.model.PullRequestStatusEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullRequestStatus())
        .map(value =>
          zio.aws.codecommit.model.PullRequestStatusEnum.wrap(value)
        )
    override val authorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.authorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val pullRequestTargets
        : Optional[List[zio.aws.codecommit.model.PullRequestTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullRequestTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.PullRequestTarget.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codecommit.model.primitives.ClientRequestToken(value)
        )
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.codecommit.model.primitives.RevisionId(value))
    override val approvalRules
        : Optional[List[zio.aws.codecommit.model.ApprovalRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.ApprovalRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequest
  ): zio.aws.codecommit.model.PullRequest.ReadOnly = new Wrapper(impl)
}
