package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  KeepEmptyFolders,
  Message,
  RepositoryName,
  Email,
  Path,
  Name,
  BranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFileRequest(
    repositoryName: RepositoryName,
    branchName: BranchName,
    filePath: Path,
    parentCommitId: CommitId,
    keepEmptyFolders: Optional[KeepEmptyFolders] = Optional.Absent,
    commitMessage: Optional[Message] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    email: Optional[Email] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteFileRequest = {
    import DeleteFileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteFileRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .filePath(Path.unwrap(filePath): java.lang.String)
      .parentCommitId(CommitId.unwrap(parentCommitId): java.lang.String)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteFileRequest.ReadOnly =
    zio.aws.codecommit.model.DeleteFileRequest.wrap(buildAwsValue())
}
object DeleteFileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteFileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteFileRequest =
      zio.aws.codecommit.model.DeleteFileRequest(
        repositoryName,
        branchName,
        filePath,
        parentCommitId,
        keepEmptyFolders.map(value => value),
        commitMessage.map(value => value),
        name.map(value => value),
        email.map(value => value)
      )
    def repositoryName: RepositoryName
    def branchName: BranchName
    def filePath: Path
    def parentCommitId: CommitId
    def keepEmptyFolders: Optional[KeepEmptyFolders]
    def commitMessage: Optional[Message]
    def name: Optional[Name]
    def email: Optional[Email]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getParentCommitId: ZIO[Any, Nothing, CommitId] =
      ZIO.succeed(parentCommitId)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteFileRequest
  ) extends zio.aws.codecommit.model.DeleteFileRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val branchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.branchName())
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val parentCommitId: CommitId =
      zio.aws.codecommit.model.primitives.CommitId(impl.parentCommitId())
    override val keepEmptyFolders: Optional[KeepEmptyFolders] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keepEmptyFolders())
        .map(value =>
          zio.aws.codecommit.model.primitives.KeepEmptyFolders(value)
        )
    override val commitMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteFileRequest
  ): zio.aws.codecommit.model.DeleteFileRequest.ReadOnly = new Wrapper(impl)
}
