package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Mode, Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BlobMetadata(
    blobId: Optional[ObjectId] = Optional.Absent,
    path: Optional[Path] = Optional.Absent,
    mode: Optional[Mode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BlobMetadata = {
    import BlobMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BlobMetadata
      .builder()
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(mode.map(value => Mode.unwrap(value): java.lang.String))(
        _.mode
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BlobMetadata.ReadOnly =
    zio.aws.codecommit.model.BlobMetadata.wrap(buildAwsValue())
}
object BlobMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BlobMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BlobMetadata =
      zio.aws.codecommit.model.BlobMetadata(
        blobId.map(value => value),
        path.map(value => value),
        mode.map(value => value)
      )
    def blobId: Optional[ObjectId]
    def path: Optional[Path]
    def mode: Optional[Mode]
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getMode: ZIO[Any, AwsError, Mode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BlobMetadata
  ) extends zio.aws.codecommit.model.BlobMetadata.ReadOnly {
    override val blobId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val path: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val mode: Optional[Mode] = zio.aws.core.internal
      .optionalFromNullable(impl.mode())
      .map(value => zio.aws.codecommit.model.primitives.Mode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BlobMetadata
  ): zio.aws.codecommit.model.BlobMetadata.ReadOnly = new Wrapper(impl)
}
